#ifndef AKTOR_H
#define AKTOR_H

#include "MacierzGL.h"
#include "Werteks.h"

class Aktor
{
protected:
	unsigned int vao, vbo;
	unsigned int liczbaWerteksw;

private:
	void InicjujBuforWerteksw();
	void UsuBuforWerteksw();

protected:	
	virtual unsigned int TwrzTablicWerteksw(CWerteks*& werteksy) = 0; //obowizki: zapenienie tablicy werteksw, zwrcenie liczby werteksw

public:	
	Macierz4 Macierzwiata;
	virtual void Inicjuj(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutWsprzdneTeksturowania, GLuint atrybutKolor); //moe by wywoywane w konstruktorach klas potomnych, ale nie klasy bazowej
	virtual void Rysuj();

	//materia
	Wektor4 MateriawiatoOtoczenia;
	Wektor4 MateriawiatoRozpraszane;
	Wektor4 MateriawiatoRozbysku;
	float MateriaWykadnikRozbysku;

	//teksturowanie
	GLuint IndeksTekstury;
	
	Aktor();	
	virtual ~Aktor();	
};

//typedef Aktor* PAktor;

//--------------------------------------------

class AktorZBuforemIndeksw : public Aktor
{
protected:
	unsigned int liczbaIndeksw;
	unsigned int vbo_indeksy;

private:
	void InicjujBuforIndeksw();
	void UsuBuforIndeksw();

protected:
	virtual unsigned int TwrzTablicIndeksw(GLuint*& indeksy) = 0;

public:
	virtual void Inicjuj(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutWsprzdneTeksturowania, GLuint atrybutKolor);
	virtual void Rysuj();

	AktorZBuforemIndeksw();
	virtual ~AktorZBuforemIndeksw();
};

//--------------------------------------------

class Kwadrat : public Aktor
{
private:
	float dugoKrawdzi;
	unsigned int TwrzTablicWerteksw(CWerteks*& werteksy);

public:
	Kwadrat(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutWsprzdneTeksturowania, GLuint atrybutKolor, float dugoKrawdzi = 2.0f);
};

class Trjkt : public Aktor
{
private:
	float dugoPodstawy, wysoko;
	unsigned int TwrzTablicWerteksw(CWerteks*& werteksy);

public:
	Trjkt(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutWsprzdneTeksturowania, GLuint atrybutKolor, float dugoPodstawy = 2.0f, float wysoko = 2.0f);
};

class KwadratZBuforemIndeksw : public AktorZBuforemIndeksw
{
private:
	float dugoKrawdzi;	
	unsigned int TwrzTablicWerteksw(CWerteks*& werteksy);
	unsigned int TwrzTablicIndeksw(GLuint*& indeksy);

public:
	KwadratZBuforemIndeksw(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutWsprzdneTeksturowania, GLuint atrybutKolor, float dugoKrawdzi = 2.0f);
};

//--------------------------------------------

class Prostopadocian : public Aktor
{
private:	
	float dugoKrawdziX, dugoKrawdziY, dugoKrawdziZ;
	bool koloruj;
	unsigned int TwrzTablicWerteksw(CWerteks*& werteksy);

public:
	void Rysuj();

	Prostopadocian(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutWsprzdneTeksturowania, GLuint atrybutKolor, float dugoKrawdziX, float dugoKrawdziY, float dugoKrawdziZ, bool koloruj);

	static Prostopadocian* StwrzSzecian(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutWsprzdneTeksturowania, GLuint atrybutKolor, float dugoKrawdzi, bool koloruj)
	{
		return new Prostopadocian(atrybutPooenie, atrybutNormalna, atrybutWsprzdneTeksturowania, atrybutKolor, dugoKrawdzi, dugoKrawdzi, dugoKrawdzi, koloruj);
	}
};


// (2) Deklaracja klasy bazowej dla aktorw zoonych z patw.
class TeselowanyAktor : public Aktor
{
protected:
	unsigned int liczbaIndeksw;
	unsigned int vbo_indeksy;

private:
	void InicjujBuforIndeksw();
	void UsuBuforIndeksw();

protected:
	virtual unsigned int TwrzTablicIndeksw(GLuint*& indeksy) = 0;

public:
	virtual void Inicjuj(GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutWsprzdneTeksturowania, GLuint atrybutKolor);
	virtual void Rysuj();

	TeselowanyAktor();
	virtual ~TeselowanyAktor();
};


// (4) Deklaracja klasy sfery zoonej z patw.
class TeselowanaSfera : public TeselowanyAktor
{
private:
	float promie;
	unsigned int liczbaSekcjiNaRwnolenikach, liczbaSekcjiNaPoudnikach;
	unsigned int TwrzTablicWerteksw(CWerteks*& werteksy);
	unsigned int TwrzTablicIndeksw(GLuint*& indeksy);
	int indeks(int i, int j);

public:
	TeselowanaSfera(
		GLuint atrybutPooenie, GLuint atrybutNormalna, GLuint atrybutWsprzdneTeksturowania, GLuint atrybutKolor,
		float promie,
		unsigned int liczbaSekcjiNaRwnolenikach = 20, unsigned int liczbaSekcjiNaPoudnikach = 20)
		:TeselowanyAktor(), promie(promie), liczbaSekcjiNaRwnolenikach(liczbaSekcjiNaRwnolenikach), liczbaSekcjiNaPoudnikach(liczbaSekcjiNaPoudnikach)
	{
		Inicjuj(atrybutPooenie, atrybutNormalna, atrybutWsprzdneTeksturowania, atrybutKolor);
	}
};

#endif
