#version 460 core

layout (location = 0) in vec3 polozenie_in;
layout (location=1) in vec3 normalna_in; // zmiana
layout (location = 3) in vec4 kolor_in;

const mat4 macierzJednostkowa = mat4(1.0);

uniform mat4 macierzSwiata = macierzJednostkowa;
uniform mat4 macierzNormalnych = macierzJednostkowa;

out vec4 kolorVertToTesc;

out vec3 polozenie_scena_vert; // zmiana
out vec3 normalna_scena_vert; // zmiana

void main()
{
	vec4 polozenie = vec4(polozenie_in, 1.0);
	gl_Position = polozenie;

	kolorVertToTesc = kolor_in;

	polozenie_scena_vert = mat3(macierzSwiata)*polozenie_in; // zmiana
	normalna_scena_vert = mat3(macierzNormalnych)*normalna_in; // zmiana
}
