#version 460 core

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;

in vec4 kolorTeseToGeom[]; 
in vec3 polozenie_scena_tese[]; // zmiana
in vec3 normalna_scena_tese[]; // zmiana

out vec4 kolorGeomToFrag;
out vec3 polozenie_scena_geom; // zmiana
out vec3 normalna_scena_geom; // zmiana

uniform vec3 srodekSfery;
uniform float promienSfery;

const mat4 macierzJednostkowa = mat4(1.0);
uniform mat4 macierzSwiata = macierzJednostkowa;
uniform mat4 macierzWidoku = macierzJednostkowa;
uniform mat4 macierzRzutowania = macierzJednostkowa;
uniform mat4 macierzNormalnych = macierzJednostkowa;
mat4 macierzMVP = macierzRzutowania * macierzWidoku * macierzSwiata;

void main()
{
	for (int i = 0; i < 3; i++)
	{
		vec3 A = srodekSfery;
		vec4 B = gl_in[i].gl_Position;
		vec4 kierunekPrzesuniecia = B - vec4(A, 1);

		vec4 wektorPrzesuniecia = normalize(kierunekPrzesuniecia) * promienSfery;

		gl_Position = macierzMVP * (vec4(srodekSfery, 1) + vec4(wektorPrzesuniecia));

		kolorGeomToFrag = kolorTeseToGeom[i];

		polozenie_scena_geom = polozenie_scena_tese[i]; // zmiana
		normalna_scena_geom = polozenie_scena_tese[i]; // zmiana

		EmitVertex();
	}

	EndPrimitive();
}
