#include "OknoGL.h"
#include "Werteks.h"
#include "resource.h"
#include "glew.h"
#include "wglew.h"
#include "Kwadryka.h"

#include <math.h>

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	return okno.WndProc(hWnd, message, wParam, lParam);
}

void Testy()
{
	int ziarno = rand();

	Wektor3 w;
	Wektor3 w1 = -w;

	/*
	Macierz4 m = Macierz4::Jednostkowa;	
	Macierz4 kopia = m;
	m.UstawElement(0, 0, 2);
	const Macierz4 k = kopia;
	float a = k[0];
	*/

	//*
	if (!TestyMacierzyKwadratowej<float, 1>(ziarno)) MessageBox(NULL, "Niezaliczony test: TestMacierzyKwadratowej<float, 1>", "", MB_OK | MB_ICONERROR);
	else MessageBox(NULL, "Zaliczony test: TestMacierzyKwadratowej<float, 1>", "", MB_OK | MB_ICONINFORMATION);
	if (!TestyMacierzyKwadratowej<float, 2>(ziarno)) MessageBox(NULL, "Niezaliczony test: TestMacierzyKwadratowej<float, 2>", "", MB_OK | MB_ICONERROR);
	else MessageBox(NULL, "Zaliczony test: TestMacierzyKwadratowej<float, 2>", "", MB_OK | MB_ICONINFORMATION);
	if (!TestyMacierzyKwadratowej<float, 3>(ziarno)) MessageBox(NULL, "Niezaliczony test: TestMacierzyKwadratowej<float, 3>", "", MB_OK | MB_ICONERROR);
	else MessageBox(NULL, "Zaliczony test: TestMacierzyKwadratowej<float, 3>", "", MB_OK | MB_ICONINFORMATION);
	if (!TestyMacierzyKwadratowej<float, 4>(ziarno)) MessageBox(NULL, "Niezaliczony test: TestMacierzyKwadratowej<float, 4>", "", MB_OK | MB_ICONERROR);
	else MessageBox(NULL, "Zaliczony test: TestMacierzyKwadratowej<float, 4>", "", MB_OK | MB_ICONINFORMATION);
	if (!TestyMacierzyKwadratowej<double, 3>(ziarno)) MessageBox(NULL, "Niezaliczony test: TestMacierzyKwadratowej<double, 3>", "", MB_OK | MB_ICONERROR);
	else MessageBox(NULL, "Zaliczony test: TestMacierzyKwadratowej<double, 3>", "", MB_OK | MB_ICONINFORMATION);
	if (!TestyMacierzyKwadratowej<double, 4>(ziarno)) MessageBox(NULL, "Niezaliczony test: TestMacierzyKwadratowej<double, 4>", "", MB_OK | MB_ICONERROR);
	else MessageBox(NULL, "Zaliczony test: TestMacierzyKwadratowej<double, 4>", "", MB_OK | MB_ICONINFORMATION);
	//*/

	if (!TestyMacierzyGrafika3D<double>(ziarno, 1E-14)) MessageBox(NULL, "Niezaliczony test: TestMacierzyGrafika3D<double>", "", MB_OK | MB_ICONERROR);
	else MessageBox(NULL, "Zaliczony test: TestyMacierzyGrafika3D<double>", "", MB_OK | MB_ICONINFORMATION);
	if (!TestyMacierzyGrafika3D<float>(ziarno, (float)1E-5)) MessageBox(NULL, "Niezaliczony test: TestMacierzyGrafika3D<float>", "", MB_OK | MB_ICONERROR);
	else MessageBox(NULL, "Zaliczony test: TestyMacierzyGrafika3D<float>", "", MB_OK | MB_ICONINFORMATION);

	if (!TestyWektora3<double>(ziarno)) MessageBox(NULL, "Niezaliczony test: TestWektora3<double>", "", MB_OK | MB_ICONERROR);
	else MessageBox(NULL, "Zaliczony test: TestyWektora3<double>", "", MB_OK | MB_ICONINFORMATION);
	if (!TestyWektora3<float>(ziarno)) MessageBox(NULL, "Niezaliczony test: TestWektora3<float>", "", MB_OK | MB_ICONERROR);
	else MessageBox(NULL, "Zaliczony test: TestyWektora3<float>", "", MB_OK | MB_ICONINFORMATION);


	exit(EXIT_SUCCESS);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
	LPSTR lpCmdLine, int nCmdShow)
{
	//Testy();

	POINT polozenieOkna = { 100, 100 };
	POINT rozmiarOkna = { 800, 600 };
	if (!okno.Inicjuj(hInstance, polozenieOkna, rozmiarOkna))
	{
		MessageBox(NULL, "Inicjacja okna nie powioda si", "Aplikacja OpenGL", MB_OK | MB_ICONERROR);
		return EXIT_FAILURE;
	}
	else return okno.Uruchom();
}

LRESULT COkno::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_DESTROY: //zamykanie okna => koczenie aplikacji
		PostQuitMessage(0);
		break;
	case WM_SIZE: //Zmiana rozmiaru okna
		RECT rect;
		GetClientRect(hWnd, &rect);
		szerokoscObszaruUzytkownika = rect.right - rect.left;
		wysokoscObszaruUzytkownika = rect.bottom - rect.top;
		break;
	default: //automatyczne przetwarzanie komunikatw
		return (DefWindowProc(hWnd, message, wParam, lParam));
	}

	return 0L;
}

bool COkno::Inicjuj(HINSTANCE uchwytAplikacji, POINT polozenieOkna, POINT rozmiarOkna, bool trybPelnoekranowy, bool zmianaRozdzielczosci)
{
	char nazwaOkna[] = "Aplikacja OpenGL";

	WNDCLASSEX wc;
	wc.cbSize = sizeof(wc);
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC; //styl okna
	wc.lpfnWndProc = (WNDPROC)::WndProc; //procedura okna
	wc.cbClsExtra = 0; //dodatkowe bajty zarezerwowane za klas okna
	wc.cbWndExtra = 0; //dodatkowe bajty zarezerwowane za instancj okna
	wc.hInstance = uchwytAplikacji; //instancja aplikacji
	//wc.hIcon = NULL; //uchwyt ikony
	//wc.hIconSm = NULL; //uchwyt ikony
	wc.hIcon = LoadIcon(uchwytAplikacji, MAKEINTRESOURCE(IDI_ICON1)); //uchwyt ikony
	wc.hIconSm = LoadIcon(uchwytAplikacji, MAKEINTRESOURCE(IDI_ICON1)); //uchwyt ikony
	wc.hCursor = LoadCursor(NULL, IDC_ARROW); //uchwyt kursora
	wc.hbrBackground = NULL; //uchwyt pdzla ta
	wc.lpszMenuName = NULL; //nazwa menu
	wc.lpszClassName = nazwaOkna; //nazwa klasy okna   

	//Rejestracja klasy okna
	if (RegisterClassEx(&wc) == 0) return false;

	//ustawienia dla okna
	DWORD stylOkna = WS_OVERLAPPEDWINDOW;

	if (trybPelnoekranowy)
	{
		//ustawienia dla trybu penoekranowego
		stylOkna = WS_POPUP;
		polozenieOkna.x = 0;
		polozenieOkna.y = 0;
		if (zmianaRozdzielczosci)
		{
			rozmiarOkna.x = 1024;
			rozmiarOkna.y = 768;
			if (!ZmianaRozdzielczosci(rozmiarOkna.x, rozmiarOkna.y)) return false;
		}
		else
		{
			RECT rozmiarEkranu;
			GetWindowRect(GetDesktopWindow(), &rozmiarEkranu);
			rozmiarOkna.x = rozmiarEkranu.right - rozmiarEkranu.left;
			rozmiarOkna.y = rozmiarEkranu.bottom - rozmiarEkranu.top;
		}
	}

	//Tworzenie okna
	uchwytOkna = CreateWindow(
		nazwaOkna, //nazwa klasy okna
		nazwaOkna, //nazwa okna
		stylOkna, //styl okna
		polozenieOkna.x, polozenieOkna.y, //pooenie okna (x,y)
		rozmiarOkna.x, rozmiarOkna.y, //rozmiar okna (szeroko, wysoko)
		NULL, //uchwyt okna nadrzdnego (parent)
		NULL, //uchwyt menu
		uchwytAplikacji, //uchwyt instancji aplikacji
		NULL //parametr komunikatu informujacego o utworzeniu okna
		);

	if (uchwytOkna == NULL) return false;

	//Pokazanie i aktualizacja okna
	ShowWindow(uchwytOkna, SW_SHOW);
	UpdateWindow(uchwytOkna);

	return true;
}

bool COkno::ZmianaRozdzielczosci(long szerokosc, long wysokosc, long glebiaKolorow) const
{
	DEVMODE dmScreenSettings;   //struktura trybu wywietlania
	memset(&dmScreenSettings, 0, sizeof(dmScreenSettings)); //czyszczenie pamici
	dmScreenSettings.dmSize = sizeof(dmScreenSettings);     //rozmiar struktury
	dmScreenSettings.dmPelsWidth = szerokosc;        //nowa szeroko ekranu
	dmScreenSettings.dmPelsHeight = wysokosc;        //nowa wysoko ekranu
	dmScreenSettings.dmBitsPerPel = glebiaKolorow;     //ilo bitw na piksel
	dmScreenSettings.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;
	return ChangeDisplaySettings(&dmScreenSettings, CDS_FULLSCREEN) == DISP_CHANGE_SUCCESSFUL;
}

WPARAM COkno::Uruchom()
{
	//Ptla gwna - obsuga komunikatw
	MSG msg;
	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

//---------------------------------------------------

bool COknoGL::UstalFormatPikseli(HDC uchwytDC) const
{	
	PIXELFORMATDESCRIPTOR opisFormatuPikseli;
	ZeroMemory(&opisFormatuPikseli, sizeof(opisFormatuPikseli));
	opisFormatuPikseli.nVersion = 1;
	opisFormatuPikseli.dwFlags = PFD_SUPPORT_OPENGL | PFD_DRAW_TO_WINDOW | PFD_DOUBLEBUFFER; //w oknie, podwojne buforowanie 
	opisFormatuPikseli.iPixelType = PFD_TYPE_RGBA; //typ koloru RGB z kanalem alfa
	opisFormatuPikseli.cColorBits = 32; //jako kolorw 4 bajty (po bajcie na kady kana)
	opisFormatuPikseli.cDepthBits = 32; //glboko bufora gbii (z-buffer) 
	opisFormatuPikseli.iLayerType = PFD_MAIN_PLANE;

	int formatPikseli = ChoosePixelFormat(uchwytDC, &opisFormatuPikseli);
	if (formatPikseli == 0) return false;

	if (!SetPixelFormat(uchwytDC, formatPikseli, &opisFormatuPikseli)) return false;
	return true;
}

bool COknoGL::InicjujWGL(HWND uchwytOkna)
{
	uchwytDC = ::GetDC(uchwytOkna);
	if (!UstalFormatPikseli(uchwytDC)) return false;

	HGLRC uchwytTymczasowegoRC = wglCreateContext(uchwytDC); //tworzenie tymczasowego kontekstu renderowania (tradycyjnie)
	if (uchwytTymczasowegoRC == NULL) return false;
	if (!wglMakeCurrent(uchwytDC, uchwytTymczasowegoRC)) return false;

	GLenum err = glewInit();
	if (GLEW_OK != err)
	{
		MessageBox(NULL, "Inicjacja biblioteki GLEW nie powioda si", "Aplikacja OpenGL", MB_OK | MB_ICONERROR);
		return false;
	}

	const int major_min = 3; const int minor_min = 3;
	int major, minor; glGetIntegerv(GL_MAJOR_VERSION, &major); glGetIntegerv(GL_MINOR_VERSION, &minor);
	if (major<major_min || (major==major_min && minor<minor_min))
	{
		MessageBox(NULL, "Wersja OpenGL jest niewystarczajca", "Aplikacja OpenGL", MB_OK | MB_ICONERROR);
		return false;
	}

	int atrybuty[] =
	{
		WGL_CONTEXT_MAJOR_VERSION_ARB, major_min,
		WGL_CONTEXT_MINOR_VERSION_ARB, minor_min,
		WGL_CONTEXT_FLAGS_ARB, WGL_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB,
		//WGL_CONTEXT_PROFILE_MASK_ARB, WGL_CONTEXT_COMPATIBILITY_PROFILE_BIT_ARB,
		WGL_CONTEXT_PROFILE_MASK_ARB, WGL_CONTEXT_CORE_PROFILE_BIT_ARB,		
		0
	};

	uchwytRC = wglCreateContextAttribsARB(uchwytDC, 0, atrybuty); //tworzenie zasadniczego kontekstu dla OpenGL 3.3+
	if (uchwytRC == NULL) return false;
	if (!wglMakeCurrent(uchwytDC, uchwytRC)) return false;

	wglDeleteContext(uchwytTymczasowegoRC); //usuniecie juz niepotrzebnego tymczasowego kontekstu renderowania

	return true;
}

void COknoGL::UsuWGL()
{
	wglMakeCurrent(NULL, NULL);
	wglDeleteContext(uchwytRC);
	::ReleaseDC(uchwytOkna, uchwytDC);
}

LRESULT COknoGL::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	long wynik = COkno::WndProc(hWnd, message, wParam, lParam);

	static POINT poprzedniaPozycjaKursoraMyszyLMB = { -1, -1 };
	static POINT poprzedniaPozycjaKursoraMyszyRMB = { -1, -1 };

	const bool swobodneObrotyKameryMoliwe = true; //gwny wycznik swobodnych obrotw kamery
	const int identyfikatorTimeraSwobodnychObrotwKamery = 1;
	const int okresTimeraSwobodnychObrotwKamery = 50; //50ms

	const bool animacjaMoliwa = true; //cykliczne wywoywanie metody AnimujScen
	const int identyfikatorTimeraAnimacji = 0;
	const int okresTimeraAnimacji = 50; //50ms

	switch (message)
	{
		case WM_CREATE: //Utworzenie okna
		//zmienna uchwytOkna nie jest jeszcze zainicjowana
		if (!InicjujWGL(hWnd))
		{
   			MessageBox(NULL, "Pobranie kontekstu renderowania nie powiodo si", "Aplikacja OpenGL", MB_OK | MB_ICONERROR);
   			exit(EXIT_FAILURE);
		}

		idProgramuShaderowSkybox = PrzygotujShadery(
   			"Skybox.vert",
   			nullptr,
   			nullptr,
   			nullptr,
   			"Skybox.frag");

		idProgramuShaderow = PrzygotujShadery(
   			"Sfera.vert",
   			"Sfera.tesc",
   			"Sfera.tese",
   			"Sfera.geom",
   			"Sfera.frag");


		if (idProgramuShaderowSkybox == NULL || idProgramuShaderow == NULL)
		{
   			MessageBox(NULL, "Przygotowanie shaderw nie powiodo si", "Aplikacja OpenGL", MB_OK | MB_ICONERROR);
   			exit(EXIT_FAILURE);
		}

		UmieInformacjeNaPaskuTytuu(hWnd);
		if (teksturowanieWczone)
			PrzygotujTekstury(3, new char*[3] { "tekstura1.bmp", "tekstura2.bmp", "tekstura3.bmp" });
		else
		{
   			glUniform1i(glGetUniformLocation(idProgramuShaderowSkybox, "Teksturowanie"), false);
   			glUniform1i(glGetUniformLocation(idProgramuShaderow, "Teksturowanie"), false);
		}

		PrzygotujTeksturySkybox();

		liczbaAktorw = PrzygotujAktorw();
		UstawienieSceny();
		if (swobodneObrotyKameryMoliwe)
		{
   			if (SetTimer(hWnd, identyfikatorTimeraSwobodnychObrotwKamery, okresTimeraSwobodnychObrotwKamery, NULL) == 0)
   				MessageBox(hWnd, "Nie udao si ustawi timera swobodnych obrotw kamery", "Bd", MB_OK | MB_ICONERROR);   		 
		}
		if (animacjaMoliwa)
		{
   			if (SetTimer(hWnd, identyfikatorTimeraAnimacji, okresTimeraAnimacji, NULL) == 0)
   				MessageBox(hWnd, "Nie udao si ustawi timera animacji sceny", "Bd", MB_OK | MB_ICONERROR);
		}
		break;


	case WM_DESTROY: //Zamknicie okna
		//UsuBuforWerteksw();
		UsuTekstury();
		UsuAktorw();
		UsuWGL();
		KillTimer(uchwytOkna, identyfikatorTimeraSwobodnychObrotwKamery);
		KillTimer(uchwytOkna, identyfikatorTimeraAnimacji);
		break;
	case WM_SIZE: //Zmiana rozmiaru okna
		UstawienieSceny();
		break;
	case WM_PAINT: //Okno wymaga odrysowania
		RysujScen();
		ValidateRect(hWnd, NULL);
		break;

	case WM_KEYDOWN:
		ObsugaKlawiszy(wParam);
		break;

	case WM_MOUSEMOVE:
		if (wParam & MK_LBUTTON) ObliczaniePrzesuniciaMyszy(lParam, 3.0f, poprzedniaPozycjaKursoraMyszyLMB, &COknoGL::ObsugaMyszyZWcinitymLewymKlawiszem);
		if (wParam & MK_RBUTTON) ObliczaniePrzesuniciaMyszy(lParam, 3.0f, poprzedniaPozycjaKursoraMyszyRMB, &COknoGL::ObsugaMyszyZWcinitymPrawymKlawiszem);
		break;	
	case WM_LBUTTONUP:
		poprzedniaPozycjaKursoraMyszyLMB = { -1, -1 };
		break;
	case WM_RBUTTONUP:
		poprzedniaPozycjaKursoraMyszyRMB = { -1, -1 };
		break;
	case WM_MOUSEWHEEL:
		ObsugaRolkiMyszy(wParam);
		break;

	case WM_TIMER:
		switch (wParam)
		{
		case identyfikatorTimeraSwobodnychObrotwKamery:
			if (swobodneObrotyKameryAktywne) SwobodneObrotyKamery(false);
			break;
		case identyfikatorTimeraAnimacji:
			if (animacjaAktywna) AnimujScen();
			break;
		}
		wynik = 0;
		break;
	case WM_LBUTTONDOWN:
		swobodneObrotyKameryAktywne = false;
		break;
	}

	return wynik;
}

void COknoGL::UmieInformacjeNaPaskuTytuu(HWND uchwytOkna)
{
	char bufor[256]; GetWindowText(uchwytOkna, bufor, 256);
	const GLubyte* wersja = glGetString(GL_VERSION);
	strcat_s(bufor, " | OpenGL "); strcat_s(bufor, (char*)wersja);
	const GLubyte* dostawca = glGetString(GL_VENDOR);
	strcat_s(bufor, " | "); strcat_s(bufor, (char*)dostawca);
	const GLubyte* kartaGraficzna = glGetString(GL_RENDERER);
	strcat_s(bufor, " | "); strcat_s(bufor, (char*)kartaGraficzna);
	const GLubyte* wersjaGLSL = glGetString(GL_SHADING_LANGUAGE_VERSION);
	strcat_s(bufor, " | GLSL "); strcat_s(bufor, (char*)wersjaGLSL);
	const GLubyte* wersjaGLEW = glewGetString(GLEW_VERSION);
	strcat_s(bufor, " | GLEW "); strcat_s(bufor, (char*)wersjaGLEW);
	SetWindowText(uchwytOkna, bufor);	
}

void COknoGL::UstawienieSceny(bool rzutowanieIzometryczne) //warto domylna =false
{
	glViewport(0, 0, szerokoscObszaruUzytkownika, wysokoscObszaruUzytkownika); //okno OpenGL = wntrze formy (domylnie) 

	glEnable(GL_DEPTH_TEST); //z-buffer aktywny = ukrywanie niewidocznych powierzchni 
	//glDisable(GL_DEPTH_TEST);

	//*
	glFrontFace(GL_CCW); //odtworzenie ustawie domylnych
	//glPolygonMode(GL_FRONT, GL_FILL);
	//glPolygonMode(GL_BACK, GL_LINE);
	//glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	//glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
	glCullFace(GL_BACK); //odtworzenie ustawie domylnych
	glEnable(GL_CULL_FACE);
	//*/


	//Parametry shadera
	GLint parametrUwzglednijKolorWerteksu = glGetUniformLocation(idProgramuShaderow, "UwzglednijKolorWerteksu");
	glUniform1i(parametrUwzglednijKolorWerteksu, true);

	GLint parametrKolor = glGetUniformLocation(idProgramuShaderow, "Kolor");
	float kolor[4] = { 1.0, 1.0, 0.0, 1.0 };
	glUniform4fv(parametrKolor, 1, kolor);

	//Macierze
	GLint parametrMacierzwiata = glGetUniformLocation(idProgramuShaderow, "macierzSwiata");
	macierzwiata.ZwiZIdentyfikatorem(parametrMacierzwiata, true);	

	GLint parametrMacierzWidoku = glGetUniformLocation(idProgramuShaderow, "macierzWidoku");
	macierzWidoku.UstawJednostkow();
	macierzWidoku *= Macierz4::Przesunicie(0, 0, -3);
	macierzWidoku.ZwiZIdentyfikatorem(parametrMacierzWidoku, true);	

	GLint parametrMacierzRzutowania = glGetUniformLocation(idProgramuShaderow, "macierzRzutowania");
	macierzRzutowania.ZwiZIdentyfikatorem(parametrMacierzRzutowania, false);
	float wsp = wysokoscObszaruUzytkownika / (float)szerokoscObszaruUzytkownika;
	if (!rzutowanieIzometryczne)
		//left,right,bottom,top,znear,zfar (clipping) - ustalanie frustum 
		macierzRzutowania.UstawRzutPerspektywiczny(-1.0f, 1.0f, wsp*-1.0f, wsp*1.0f, 1.0f, 10.0f);
	else
		macierzRzutowania.UstawRzutIzometryczny(-1.0f, 1.0f, wsp*-1.0f, wsp*1.0f, 1.0f, 10.0f);
	macierzRzutowania.PrzelijWarto();

	GLint parametrMacierzNormalnych = glGetUniformLocation(idProgramuShaderow, "macierzNormalnych");
	macierzNormalnych = macierzwiata.Odwrotna().Transponowana();
	macierzNormalnych.ZwiZIdentyfikatorem(parametrMacierzNormalnych, true);

	UstawParametryrdawiata(Wektor3(1, 2, 2), Wektor4(1, 1, 1, 1), Wektor4(1, 1, 1, 1), Wektor4(1, 1, 1, 1));
	UstawParametryMateriau(Wektor4(0.1f, 0.1f, 0.1f, 1), Wektor4(1, 1, 1, 1), Wektor4(0, 1, 0, 1), 100);
	UstawParametryOsabieniaOwietlenia(false, Wektor3(1, 0, 1));


	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

	GLint parametrSrodekSfery = glGetUniformLocation(idProgramuShaderow, "srodekSfery");
	glUniform3f(parametrSrodekSfery, 0,0,0);

	GLint parametrPromienSfery = glGetUniformLocation(idProgramuShaderow, "promienSfery");
	glUniform1f(parametrPromienSfery, 0.75);

	ModyfikujPooenieKamery(Macierz4::Jednostkowa); // zmiana

}




void COknoGL::UzyjProgramuShaderow(
    unsigned int programShaderow,
    bool rzutowanieIzometryczne)
{
    glUseProgram(programShaderow);

    //Macierze
    GLint parametrMacierzwiata =
   	 glGetUniformLocation(programShaderow, "macierzSwiata");
    macierzwiata.ZwiZIdentyfikatorem(
   	 parametrMacierzwiata, true);    

    GLint parametrMacierzWidoku =
   	 glGetUniformLocation(programShaderow, "macierzWidoku");
    macierzWidoku.ZwiZIdentyfikatorem(
   	 parametrMacierzWidoku, true);    

    GLint parametrMacierzRzutowania =
   	 glGetUniformLocation(programShaderow, "macierzRzutowania");
    macierzRzutowania.ZwiZIdentyfikatorem(
   	 parametrMacierzRzutowania, false);
    macierzRzutowania.PrzelijWarto();

    GLint parametrMacierzNormalnych =
   	 glGetUniformLocation(programShaderow, "macierzNormalnych");
    macierzNormalnych.ZwiZIdentyfikatorem(
   	 parametrMacierzNormalnych, true);
}


void COknoGL::UstawParametryrdawiata(Wektor3 pooenie, Wektor4 wiatoOtoczenia, Wektor4 wiatoRozpraszane, Wektor4 wiatoRozbysku)
{
	float bufor[4];
	pooenie.KopiujElementy(bufor);
	GLint parametrPooenierdawiata = glGetUniformLocation(idProgramuShaderow, "PolozenieZrodlaSwiatla");
	glUniform3fv(parametrPooenierdawiata, 1, bufor);
	
	wiatoOtoczenia.KopiujElementy(bufor);
	GLint parametrwiatoOtoczenia = glGetUniformLocation(idProgramuShaderow, "Ca");
	glUniform4fv(parametrwiatoOtoczenia, 1, bufor);

	wiatoRozpraszane.KopiujElementy(bufor);
	GLint parametrwiatoRozpraszane= glGetUniformLocation(idProgramuShaderow, "Cd");
	glUniform4fv(parametrwiatoRozpraszane, 1, bufor);

	wiatoRozbysku.KopiujElementy(bufor);
	GLint parametrwiatoRozbysku = glGetUniformLocation(idProgramuShaderow, "Cs");
	glUniform4fv(parametrwiatoRozbysku, 1, bufor);
}

void COknoGL::UstawParametryMateriau(Wektor4 wiatoOtoczenia, Wektor4 wiatoRozpraszane, Wektor4 wiatoRozbysku, float wykadnikRozbysku)
{
	float bufor[4];
	wiatoOtoczenia.KopiujElementy(bufor);
	GLint parametrwiatoOtoczenia = glGetUniformLocation(idProgramuShaderow, "Wa");
	glUniform4fv(parametrwiatoOtoczenia, 1, bufor);

	wiatoRozpraszane.KopiujElementy(bufor);
	GLint parametrwiatoRozpraszane = glGetUniformLocation(idProgramuShaderow, "Wd");
	glUniform4fv(parametrwiatoRozpraszane, 1, bufor);

	wiatoRozbysku.KopiujElementy(bufor);
	GLint parametrwiatoRozbysku = glGetUniformLocation(idProgramuShaderow, "Ws");
	glUniform4fv(parametrwiatoRozbysku, 1, bufor);

	GLint parametrWykadnikRozbysku = glGetUniformLocation(idProgramuShaderow, "WNs");
	glUniform1f(parametrWykadnikRozbysku, wykadnikRozbysku);
}

void COknoGL::UstawParametryOsabieniaOwietlenia(bool wczone, Wektor3 wspczynniki)
{
	GLint parametrTumienieOwietlenia = glGetUniformLocation(idProgramuShaderow, "OslabienieOswietlenia");
	glUniform1i(parametrTumienieOwietlenia, wczone);

	float bufor[3];
	wspczynniki.KopiujElementy(bufor);
	GLint parametrWspczynnikiTumienia = glGetUniformLocation(idProgramuShaderow, "WspolczynnikiOslabieniaOswietlenia");
	glUniform3fv(parametrWspczynnikiTumienia, 1, bufor);
}


void COknoGL::AnimujScen()
{
	for (unsigned int i = 0; i < liczbaAktorw; ++i)
	{		
		//bryy
		if (i < 5)
			aktorzy[i]->Macierzwiata.PomnZLewej(Macierz4::ObrtY(3)*Macierz4::ObrtZ(1));

		//podoe
		if (i == 5) continue;

		//cienie
		if (i > 5)
		{
			const float przesunicieY = -2.0f;
			const float korekta = 0.0001f;
			Macierz4 macierzRzutuNaPodoe = Macierz4::RzutNaPaszczyzn(Wektor3(1, 2, 2), Wektor3(0, 1, 0), -przesunicieY - korekta);
			aktorzy[i]->Macierzwiata.Ustaw(macierzRzutuNaPodoe*aktorzy[i - 6]->Macierzwiata);
		}
	}

	RysujScen();
}

void COknoGL::ustawCzas()
{
	GLint parametrCzas = glGetUniformLocation(idProgramuShaderow, "Czas");
	float czasWSekundach = GetTickCount() / 1000.0f;
	glUniform1f(parametrCzas, czasWSekundach);
}

void COknoGL::RysujScen()
{
	ustawCzas();

	//Przygotowanie bufora 
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); //czyci bufory 	

	RysujAktorw();	

	//Z bufora na ekran 
	SwapBuffers(uchwytDC);
}

#pragma region Aktorzy
unsigned int COknoGL::PrzygotujAktorw()
{
    GLuint atrybutPooenie =
   	 glGetAttribLocation(idProgramuShaderow, "polozenie_in");
    if (atrybutPooenie ==
   	 (GLuint)-1) atrybutPooenie = 0;

    GLuint atrybutNormalna =
   	 glGetAttribLocation(idProgramuShaderow, "normalna_in");
    if (atrybutNormalna == (GLuint)-1)
   	 atrybutNormalna = 1;

    GLuint atrybutWsprzdneTeksturowania =
   	 glGetAttribLocation(idProgramuShaderow, "wspTekstur_in");
    if (atrybutWsprzdneTeksturowania == (GLuint)-1)
   	 atrybutWsprzdneTeksturowania = 2;

    GLuint atrybutKolor =
   	 glGetAttribLocation(idProgramuShaderow, "kolor_in");
    if (atrybutKolor == (GLuint)-1)
   	 atrybutKolor = 3;

    GLuint atrybutPooenieSkybox =
   	 glGetAttribLocation(idProgramuShaderowSkybox, "polozenie_in");
    if (atrybutPooenieSkybox == (GLuint)-1)
   	 atrybutPooenieSkybox = 0;

    const int liczbaAktorw = 2;
    aktorzy = new Aktor*[liczbaAktorw];

    // Bryy.
    aktorzy[0] = Skybox::StwrzSkybox(atrybutPooenie, 9);
    aktorzy[0]->ProgramShaderowId = idProgramuShaderowSkybox;

    aktorzy[1] = new TeselowanaSfera(atrybutPooenie, atrybutNormalna,
   	 atrybutWsprzdneTeksturowania, atrybutKolor, 1.0f, 5, 5);
    aktorzy[1]->Macierzwiata =
   	 Macierz4::ObrtY(90) * Macierz4::ObrtX(90) * Macierz4::Przesunicie(0,0,0);
    aktorzy[1]->MateriawiatoOtoczenia = Wektor4(0.2f, 0.2f, 0.2f, 1);
    aktorzy[1]->MateriawiatoRozpraszane = Wektor4(1, 1, 1, 1);
    aktorzy[1]->MateriawiatoRozbysku = Wektor4(1, 1, 1, 1);
    aktorzy[1]->MateriaWykadnikRozbysku = 10;
    aktorzy[1]->IndeksTekstury =
   	 (teksturowanieWczone) ? indeksyTekstur[0] : -1;
    aktorzy[1]->ProgramShaderowId = idProgramuShaderow;

    return liczbaAktorw;
}


void COknoGL::RysujAktorw()
{
    for (unsigned int i = 0; i < liczbaAktorw; ++i)
    {
   	 UzyjProgramuShaderow(aktorzy[i]->ProgramShaderowId);

    	 //zachowuje zwizek z macierz shaderw,
   	 //z tego powodu nie naley uywa operatora =
   	 macierzwiata.Ustaw(aktorzy[i]->Macierzwiata);
   	 macierzwiata.PrzelijWarto();
    	 try
   	 {
   		 macierzNormalnych.Ustaw(
   			 macierzwiata.Odwrotna().Transponowana());
   	 }
   	 catch (std::exception exc)
   	 {
   		 MessageBeep(0);
   		 macierzNormalnych.Ustaw(macierzwiata);
   	 }
   	 macierzNormalnych.PrzelijWarto();
   	 UstawParametryMateriau(
   		 aktorzy[i]->MateriawiatoOtoczenia,
   		 aktorzy[i]->MateriawiatoRozpraszane,
   		 aktorzy[i]->MateriawiatoRozbysku,
   		 aktorzy[i]->MateriaWykadnikRozbysku);

   	 if (teksturowanieWczone)
   	 {
   		 glActiveTexture(GL_TEXTURE0);
   		 glBindTexture(GL_TEXTURE_2D, indeksyTekstur[0]);
   		 glUniform1i(glGetUniformLocation(
   			 idProgramuShaderow, "ProbnikTekstury0"), 0);
   			 
   		 glActiveTexture(GL_TEXTURE1);
   		 glBindTexture(GL_TEXTURE_2D, indeksyTekstur[1]);
   		 glUniform1i(glGetUniformLocation(
   			 idProgramuShaderow, "ProbnikTekstury1"), 1);

   		 glActiveTexture(GL_TEXTURE2);
   		 glBindTexture(GL_TEXTURE_2D, indeksyTekstur[2]);
   		 glUniform1i(glGetUniformLocation(
   			 idProgramuShaderow, "ProbnikTekstury2"), 2);

   		 // Do mapowania rodowiska dla sfery.
   		 glActiveTexture(GL_TEXTURE3);
   		 glBindTexture(GL_TEXTURE_CUBE_MAP, indeksTeksturySkybox);
   		 glUniform1i(glGetUniformLocation(
   			 idProgramuShaderow, "ProbnikTeksturySkybox"), 3);

   		 // Do oteksturowania skyboksa.
   		 glActiveTexture(GL_TEXTURE4);
   		 glBindTexture(GL_TEXTURE_CUBE_MAP, indeksTeksturySkybox);
   		 glUniform1i(glGetUniformLocation(
   			 idProgramuShaderowSkybox, "ProbnikTeksturySkybox"), 4);
   	 }

   	 aktorzy[i]->Rysuj();
    }
}


void COknoGL::UsuAktorw()
{
	for (unsigned int i = 0; i < liczbaAktorw; ++i) delete aktorzy[i];
	delete[] aktorzy;
	liczbaAktorw = 0;

    glDeleteTextures(1, &indeksTeksturySkybox);

}
#pragma endregion

#pragma region Shadery
void PokaKomunikat(char* tekst, UINT typ = 0)
{
	MessageBoxA(NULL, tekst, "Aplikacja OpenGL - Kompilacja shaderw", MB_OK | typ);
}

#include <fstream>
char* CzytajPlikTxt(const char* nazwaPliku, int rozmiarBufora, char* bufor)
{
	std::ifstream plik_we(nazwaPliku);
	if (plik_we.fail()) return NULL;
	plik_we.read(bufor, rozmiarBufora);
	if (plik_we.eof())
	{
		std::streamsize odczytane = plik_we.gcount();
		plik_we.close();
		bufor[odczytane] = '\0';
		return bufor;
	}
	else
	{
		plik_we.close();
		return NULL;
	}
}

GLuint COknoGL::KompilujShader(const char* nazwaPliku, GLenum typ, bool trybDebugowania)
{
	const int maksymalnaWielkoscKodu = 65535;

	//Wczytywanie kodu z pliku
	char kodShadera[maksymalnaWielkoscKodu] = "";
	if (CzytajPlikTxt(nazwaPliku, maksymalnaWielkoscKodu, kodShadera) == NULL)
	{
		PokaKomunikat("Brak lub niemoliwe odczytanie pliku shadera", MB_ICONERROR);
		return NULL;
	}
	else if (trybDebugowania) PokaKomunikat(kodShadera);

	//Tworzenie obiektu shadera
	GLuint idShadera = glCreateShader(typ);
	if (idShadera == NULL) return NULL;

	//Dostarczanie zrodla do obiektu shadera
	const GLchar* zrodlo[1];
	zrodlo[0] = kodShadera;
	glShaderSource(idShadera, 1, zrodlo, NULL);

	//Kompilacja shadera
	glCompileShader(idShadera);

	//Weryfikacje kompilacji
	GLint powodzenie;
	glGetShaderiv(idShadera, GL_COMPILE_STATUS, &powodzenie);
	if (!powodzenie)
	{
		const int maxInfoLogSize = 2048;
		GLchar infoLog[maxInfoLogSize];
		glGetShaderInfoLog(idShadera, maxInfoLogSize, NULL, infoLog);
		char komunikat[maxInfoLogSize + 64] = "Uwaga! Kompilacja shadera nie powioda si:\n";
		strcat_s(komunikat, (char*)infoLog);
		PokaKomunikat(komunikat, MB_ICONERROR);
		return NULL;
	}
	else if (trybDebugowania) PokaKomunikat("Kompilacja shadera zakoczya si sukcesem", MB_ICONINFORMATION);

	return idShadera;
}

unsigned int COknoGL::PrzygotujShadery(const char* vsNazwaPliku, const char* fsNazwaPliku, bool trybDebugowania)
{
	//Kompilacja shadera werteksw
	GLuint idShaderaWerteksw = KompilujShader(vsNazwaPliku, GL_VERTEX_SHADER, trybDebugowania);
	if (idShaderaWerteksw == NULL)
	{
		PokaKomunikat("Kompilacja shadera werteksw nie powioda si", MB_ICONERROR);
		return NULL;
	}
	else if (trybDebugowania) PokaKomunikat("Kompilacja shadera werteksw zakoczya si sukcesem", MB_ICONINFORMATION);

	//Kompilacja shadera fragmentw
	GLuint idShaderaFragmentw = KompilujShader(fsNazwaPliku, GL_FRAGMENT_SHADER, trybDebugowania);
	if (idShaderaFragmentw == NULL)
	{
		PokaKomunikat("Kompilacja shadera fragmentw nie powioda si", MB_ICONERROR);
		return NULL;
	}
	else if (trybDebugowania) PokaKomunikat("Kompilacja shadera fragmentw zakoczya si sukcesem", MB_ICONINFORMATION);

	//Tworzenie obiektu programu
	GLuint idProgramu = glCreateProgram();

	//Przylaczanie shaderow
	glAttachShader(idProgramu, idShaderaWerteksw);
	glAttachShader(idProgramu, idShaderaFragmentw);
	
	//Linkowanie
	glLinkProgram(idProgramu);

	//Weryfikacja linkowania
	GLint powodzenie;
	glGetProgramiv(idProgramu, GL_LINK_STATUS, &powodzenie);
	if (!powodzenie)
	{
		const int maxInfoLogSize = 2048;
		GLchar infoLog[maxInfoLogSize];
		glGetProgramInfoLog(idProgramu, maxInfoLogSize, NULL, infoLog);
		char komunikat[maxInfoLogSize + 64] = "Uwaga! Linkowanie programu shaderw nie powiodo si:\n";
		strcat_s(komunikat, (char*)infoLog);
		PokaKomunikat(komunikat, MB_ICONERROR);
		return NULL;
	}
	else if (trybDebugowania) PokaKomunikat("Linkowanie programu shaderw powiodo si", MB_ICONINFORMATION);

	//Walidacja programu
	glValidateProgram(idProgramu);

	//Weryfikacja walidacji
	glGetProgramiv(idProgramu, GL_VALIDATE_STATUS, &powodzenie);
	if (!powodzenie)
	{
		const int maxInfoLogSize = 2048;
		GLchar infoLog[maxInfoLogSize];
		glGetProgramInfoLog(idProgramu, maxInfoLogSize, NULL, infoLog);
		char komunikat[maxInfoLogSize + 64] = "Uwaga! Walidacja programu shaderw nie powioda si:\n";
		strcat_s(komunikat, (char*)infoLog);
		PokaKomunikat(komunikat, MB_ICONERROR);
		return NULL;
	}
	else if (trybDebugowania) PokaKomunikat("Walidacja programu shaderw powioda si", MB_ICONINFORMATION);

	//Uzycie programu
	glUseProgram(idProgramu);

	//Usuwanie niepotrzebnych obiektow shadera
	glDeleteShader(idShaderaWerteksw);
	glDeleteShader(idShaderaFragmentw);

	return idProgramu;
}

// (12) Definicja przecionej metody.
unsigned int COknoGL::PrzygotujShadery(
	const char* fileNameVertexShader,
	const char* fileNameTesselationControlShader,	
	const char* fileNameTesselationEvaluationShader,
	const char* fileNameGeometryShader,
	const char* fileNameFragmentShader,
	bool trybDebugowania)
{
	//Tworzenie obiektu programu
	GLuint idProgramu = glCreateProgram();

	// 1. Kompilacja shadera werteksw
	GLuint idShaderaWerteksw = NULL;
	if (fileNameVertexShader != nullptr)
	{
		idShaderaWerteksw = KompilujShader(fileNameVertexShader, GL_VERTEX_SHADER, trybDebugowania);
		if (idShaderaWerteksw == NULL)
		{
			PokaKomunikat("Kompilacja shadera werteksw nie powioda si", MB_ICONERROR);
			return NULL;
		}
		else if (trybDebugowania) PokaKomunikat("Kompilacja shadera werteksw zakoczya si sukcesem", MB_ICONINFORMATION);

		glAttachShader(idProgramu, idShaderaWerteksw); //Przylaczanie shadera
	}

	// 2. Kompilacja shadera kontroli teselacji.
	GLuint idTesselationControlShader = NULL;
	if (fileNameTesselationControlShader != nullptr)
	{
		idTesselationControlShader = KompilujShader(fileNameTesselationControlShader, GL_TESS_CONTROL_SHADER, trybDebugowania);
		if (idTesselationControlShader == NULL)
		{
			PokaKomunikat("Kompilacja shadera kontroli teselacji nie powioda si", MB_ICONERROR);
			return NULL;
		}
		else if (trybDebugowania) PokaKomunikat("Kompilacja shadera kontroli teselacji zakoczya si sukcesem", MB_ICONINFORMATION);

		glAttachShader(idProgramu, idTesselationControlShader); //Przylaczanie shadera
	}

	// 3. Kompilacja shadera ewaluacji teselacji.
	GLuint idTesselationEvaluationShader = NULL;
	if (fileNameTesselationEvaluationShader != nullptr)
	{
		idTesselationEvaluationShader = KompilujShader(fileNameTesselationEvaluationShader, GL_TESS_EVALUATION_SHADER, trybDebugowania);
		if (idTesselationEvaluationShader == NULL)
		{
			PokaKomunikat("Kompilacja shadera ewaluacji teselacji nie powioda si", MB_ICONERROR);
			return NULL;
		}
		else if (trybDebugowania) PokaKomunikat("Kompilacja shadera ewaluacji teselacji zakoczya si sukcesem", MB_ICONINFORMATION);

		glAttachShader(idProgramu, idTesselationEvaluationShader); //Przylaczanie shadera
	}

	// 4. Kompilacja shadera geometrii
	GLuint idGeometryShader = NULL;
	if (fileNameGeometryShader != nullptr)
	{
		idGeometryShader = KompilujShader(fileNameGeometryShader, GL_GEOMETRY_SHADER, trybDebugowania);
		if (idGeometryShader == NULL)
		{
			PokaKomunikat("Kompilacja shadera geometrii nie powioda si", MB_ICONERROR);
			return NULL;
		}
		else if (trybDebugowania) PokaKomunikat("Kompilacja shadera geometrii zakoczya si sukcesem", MB_ICONINFORMATION);

		glAttachShader(idProgramu, idGeometryShader); //Przylaczanie shadera
	}

	// 5. Kompilacja shadera fragmentw
	GLuint idShaderaFragmentw = NULL;
	if (fileNameFragmentShader != nullptr)
	{
		idShaderaFragmentw = KompilujShader(fileNameFragmentShader, GL_FRAGMENT_SHADER, trybDebugowania);
		if (idShaderaFragmentw == NULL)
		{
			PokaKomunikat("Kompilacja shadera fragmentw nie powioda si", MB_ICONERROR);
			return NULL;
		}
		else if (trybDebugowania) PokaKomunikat("Kompilacja shadera fragmentw zakoczya si sukcesem", MB_ICONINFORMATION);

		glAttachShader(idProgramu, idShaderaFragmentw); //Przylaczanie shadera
	}

	// Linkowanie.
	glLinkProgram(idProgramu);

	// Weryfikacja linkowania.
	GLint czyPowodzenie;
	glGetProgramiv(idProgramu, GL_LINK_STATUS, &czyPowodzenie);
	if (!czyPowodzenie)
	{
		const int maxInfoLogSize = 2048;
		GLchar infoLog[maxInfoLogSize];
		glGetProgramInfoLog(idProgramu, maxInfoLogSize, NULL, infoLog);
		char komunikat[maxInfoLogSize + 64] = "Uwaga! Linkowanie programu shaderw nie powiodo si:\n";
		strcat_s(komunikat, (char*)infoLog);
		PokaKomunikat(komunikat, MB_ICONERROR);
		return NULL;
	}
	else if (trybDebugowania) 
		PokaKomunikat("Linkowanie programu shaderw powiodo si", MB_ICONINFORMATION);

	// Walidacja programu.
	glValidateProgram(idProgramu);

	// Weryfikacja walidacji.
	glGetProgramiv(idProgramu, GL_VALIDATE_STATUS, &czyPowodzenie);
	if (!czyPowodzenie)
	{
		const int maxInfoLogSize = 2048;
		GLchar infoLog[maxInfoLogSize];
		glGetProgramInfoLog(idProgramu, maxInfoLogSize, NULL, infoLog);
		char komunikat[maxInfoLogSize + 64] = "Uwaga! Walidacja programu shaderw nie powioda si:\n";
		strcat_s(komunikat, (char*)infoLog);
		PokaKomunikat(komunikat, MB_ICONERROR);
		return NULL;
	}
	else if (trybDebugowania)
		PokaKomunikat("Walidacja programu shaderw powioda si", MB_ICONINFORMATION);

	// Uzycie programu.
	glUseProgram(idProgramu);

	// Usuwanie niepotrzebnych obiektow shadera.

	if (idShaderaWerteksw != NULL)
		glDeleteShader(idShaderaWerteksw);
	if (idTesselationControlShader != NULL)
		glDeleteShader(idTesselationControlShader);
	if (idTesselationEvaluationShader != NULL)
		glDeleteShader(idTesselationEvaluationShader);
	if (idGeometryShader != NULL)
		glDeleteShader(idGeometryShader);
	if (idShaderaFragmentw != NULL)
		glDeleteShader(idShaderaFragmentw);

	return idProgramu;
}


#pragma endregion

#pragma region Obsuga klawiatury i myszy
Wektor3 COknoGL::PobierzPooenieKamery(bool pomiObroty) const //pooenie kamery w ukadzie sceny
{
	Wektor3 w3;
	if(pomiObroty)
	{
		Wektor4 w4 = macierzWidoku.KopiaKolumny(3);	
		for (int i = 0; i < 3; ++i) w3[i] = -w4[i];
	}
	else
	{
		Wektor4 w4 = macierzWidoku.Odwrotna().KopiaKolumny(3);
		for (int i = 0; i < 3; ++i) w3[i] = w4[i];
	}
	return w3;
}

float COknoGL::OdlegoKamery() const
{
	return PobierzPooenieKamery().Dugo();
}

void COknoGL::ModyfikujPooenieKamery(Macierz4 macierzPrzeksztacenia)
{
	switch (trybKontroliKamery)
	{
	case tkkFPP:
		macierzWidoku.PomnZLewej(macierzPrzeksztacenia);
		break;
	case tkkTPP:
	{
		const float odlegoCentrumOdKamery = 3.0f;
		macierzWidoku.PomnZLewej(Macierz4::Przesunicie(0, 0, -odlegoCentrumOdKamery)*macierzPrzeksztacenia*Macierz4::Przesunicie(0, 0, odlegoCentrumOdKamery));
	}
		break;
	case tkkArcBall:
	{
		Wektor3 pooenieKamery = PobierzPooenieKamery(true);
		macierzWidoku.PomnZLewej(Macierz4::Przesunicie(-pooenieKamery)*macierzPrzeksztacenia*Macierz4::Przesunicie(pooenieKamery));
	}
		break;
	case tkkModel:
		macierzWidoku.PomnZPrawej(macierzPrzeksztacenia);
	}
	macierzWidoku.PrzelijWarto();
	
	float pooenieKamery[3];
	PobierzPooenieKamery(false).KopiujElementy(pooenieKamery);
	GLint parametrPooenieKamery = glGetUniformLocation(idProgramuShaderow, "PolozenieKamery");
	glUniform3fv(parametrPooenieKamery, 1, pooenieKamery);
}

void COknoGL::ObsugaKlawiszy(WPARAM wParam)
{
	const float kt = 5.0f;
	Macierz4 m = Macierz4::Jednostkowa;
	switch (wParam)
	{
	case 27:
		SendMessage(uchwytOkna, WM_CLOSE, 0, 0);
		break;
	case VK_F5:
	{
		bool komunikatNaPaskuTytuu = true;
		switch (trybKontroliKamery)
		{
		case tkkFPP:
			trybKontroliKamery = tkkTPP;
			if (komunikatNaPaskuTytuu) SetWindowText(uchwytOkna, "Tryb kontroli kamery: TPP");
			break;
		case tkkTPP:
			trybKontroliKamery = tkkArcBall;
			if (komunikatNaPaskuTytuu) SetWindowText(uchwytOkna, "Tryb kontroli kamery: ArcBall");
			break;
		case tkkArcBall:
			trybKontroliKamery = tkkModel;
			if (komunikatNaPaskuTytuu) SetWindowText(uchwytOkna, "Tryb kontroli kamery: Model");
			break;
		case tkkModel:
			trybKontroliKamery = tkkFPP;
			if (komunikatNaPaskuTytuu) SetWindowText(uchwytOkna, "Tryb kontroli kamery: FPP");
			break;
		}
		MessageBeep(MB_OK);
	}
		break;
	case VK_F6:
		animacjaAktywna = !animacjaAktywna;
		MessageBeep(MB_OK);
		break;
	case 'A':
	case VK_LEFT:
		m = Macierz4::ObrtY(kt);
		break;
	case 'D':
	case VK_RIGHT:
		m = Macierz4::ObrtY(-kt);
		break;
	case 'W':
	case VK_UP:
		m = Macierz4::ObrtX(kt);
		break;
	case 'S':
	case VK_DOWN:
		m = Macierz4::ObrtX(-kt);
		break;
	case VK_OEM_COMMA:
		m = Macierz4::ObrtZ(kt);
		break;
	case VK_OEM_PERIOD:
		m = Macierz4::ObrtZ(-kt);
		break;
	case VK_OEM_MINUS:
		m = Macierz4::Przesunicie(0, 0, 0.1f);
		break;
	case VK_OEM_PLUS:
		m = Macierz4::Przesunicie(0, 0, -0.1f);
		break;
	}
	ModyfikujPooenieKamery(m);
	RysujScen();
}

void COknoGL::ObliczaniePrzesuniciaMyszy(const LPARAM lParam, const float prg, POINT& poprzedniaPozycjaKursoraMyszy, TypMetodyObsugujcejPrzesunicieMyszy MetodaObsugujcaPrzesunicieMyszy)
{
	if (poprzedniaPozycjaKursoraMyszy.x == -1 && poprzedniaPozycjaKursoraMyszy.y == -1)
	{
		poprzedniaPozycjaKursoraMyszy = { LOWORD(lParam), HIWORD(lParam) };
		return;
	}
	POINT biecaPozycjaKursoraMyszy = { LOWORD(lParam), HIWORD(lParam) };
	POINT przesunicie;
	przesunicie.x = biecaPozycjaKursoraMyszy.x - poprzedniaPozycjaKursoraMyszy.x;
	przesunicie.y = biecaPozycjaKursoraMyszy.y - poprzedniaPozycjaKursoraMyszy.y;
	float przesunicieKursoraMyszy = (float)sqrt(przesunicie.x*przesunicie.x + przesunicie.y*przesunicie.y);
	
	if (przesunicieKursoraMyszy > prg) 
	//prg w pikselach
	//zapobiega zbyt czstym zmianom - utrata dokadnoci
	{
		(this->*MetodaObsugujcaPrzesunicieMyszy)(biecaPozycjaKursoraMyszy, przesunicie);
		poprzedniaPozycjaKursoraMyszy = biecaPozycjaKursoraMyszy;
	}
}

void COknoGL::ObsugaMyszyZWcinitymLewymKlawiszem(POINT biecaPozycjaKursoraMyszy, POINT przesunicieKursoraMyszy)
{
	//skalowanie
	const float wspX = 360.0f / szerokoscObszaruUzytkownika;
	const float wspY = 360.0f / wysokoscObszaruUzytkownika;
	float dx = przesunicieKursoraMyszy.x * wspX;
	float dy = przesunicieKursoraMyszy.y * wspY;

	//Macierz4 m = Macierz4::ObrtY(dx)*Macierz4::ObrtX(dy);
	Macierz4 m = Macierz4::ObrtXYZ(dy, dx, 0);

	ModyfikujPooenieKamery(m);
	RysujScen();

	SwobodneObrotyKamery(true, dx, dy, 0.95f); //inicjacja swobodnych obrotw kamery
}

void COknoGL::ObsugaMyszyZWcinitymPrawymKlawiszem(POINT biecaPozycjaKursoraMyszy, POINT przesunicieKursoraMyszy)
{
	//skalowanie
	const float wspX = 5.0f / szerokoscObszaruUzytkownika;
	const float wspY = 5.0f / wysokoscObszaruUzytkownika;
	float dx = przesunicieKursoraMyszy.x * wspX;
	float dy = przesunicieKursoraMyszy.y * wspY;

	Macierz4 m = Macierz4::Przesunicie(dx, -dy, 0);

	ModyfikujPooenieKamery(m);
	RysujScen();
}

void COknoGL::ObsugaRolkiMyszy(WPARAM wParam)
{
	const float czuo = 10.0f;
	short zmianaPozycjiRolki = (short)HIWORD(wParam);
	float przesuniecie = zmianaPozycjiRolki / abs(zmianaPozycjiRolki) / czuo;
	ModyfikujPooenieKamery(Macierz4::Przesunicie(0, 0, przesuniecie)); //tu w niektrych trybach w kierunku pooenia kamery
	RysujScen();
}

void COknoGL::SwobodneObrotyKamery(const bool inicjacja, const float pocztkowe_dx, const float pocztkowe_dy, const float wspczynnikWygaszania)
{
	static float dx = 0;
	static float dy = 0;
	static float wsp = 0;
	if (inicjacja)
	{
		swobodneObrotyKameryAktywne = true;
		dx = pocztkowe_dx;
		dy = pocztkowe_dy;
		wsp = wspczynnikWygaszania; if (wsp < 0) wsp = 0; if (wsp>1) wsp = 1;
		return;
	}
	else
	{
		dx *= wsp;
		dy *= wsp;
		if (fabs(dx) < 0.001f && fabs(dy) < 0.001f) swobodneObrotyKameryAktywne = false;
		Macierz4 m = Macierz4::ObrtXYZ(dy, dx, 0);
		ModyfikujPooenieKamery(m);
		RysujScen();
	}
}
#pragma endregion

#pragma region Teksturowanie
#include "Pliki.h"

void COknoGL::PrzygotujTekstury(unsigned int liczbaTekstur, char** nazwyPlikwTekstur)
{
	indeksyTekstur = new GLuint[liczbaTekstur];
	glGenTextures(liczbaTekstur, indeksyTekstur); //generowanie indeksow dla tekstur (uchwyt)
	
	int szerokoTekstury;
	int wysokoTekstury;
	for (unsigned int i = 0; i<liczbaTekstur; ++i)
	{
		glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D, indeksyTekstur[i]); //kolejne polecenia beda dotyczyc tej tekstury
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
		
		//wczytywanie tekstury z pliku
		unsigned long* tekstura = WczytajObrazZPlikuBitmap(uchwytOkna, nazwyPlikwTekstur[i], szerokoTekstury, wysokoTekstury, false, 255);
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, szerokoTekstury, wysokoTekstury, 0, GL_RGBA, GL_UNSIGNED_BYTE, tekstura);
		delete[] tekstura;

		//generowanie mipmap
		glHint(GL_GENERATE_MIPMAP_HINT, GL_NICEST);
		glGenerateMipmap(GL_TEXTURE_2D);
	}

	glBindTexture(GL_TEXTURE_2D, NULL);
}

void COknoGL::PrzygotujTeksturySkybox()
{
    glGenTextures(1, &indeksTeksturySkybox);
    glBindTexture(GL_TEXTURE_CUBE_MAP, indeksTeksturySkybox);

    glTexParameteri(GL_TEXTURE_CUBE_MAP,
   	 GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_CUBE_MAP,
   	 GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_CUBE_MAP,
   	 GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
    glTexParameteri(GL_TEXTURE_CUBE_MAP,
   	 GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
    glTexParameteri(GL_TEXTURE_CUBE_MAP,
   	 GL_TEXTURE_WRAP_R, GL_CLAMP_TO_EDGE);

    char* nazwyTekstur[] =
    {
   	 "skybox-right.bmp", "skybox-left.bmp", "skybox-up.bmp",
   	 "skybox-down.bmp", "skybox-front.bmp", "skybox-back.bmp"
    };

	int wysokosc;
	int szerokosc;
    unsigned long* tekstura;  

    for(unsigned int i = 0; i < 6; i++)
    {
   	 tekstura = WczytajObrazZPlikuBitmap(
   		 uchwytOkna, nazwyTekstur[i],
   		 szerokosc, wysokosc, false, 255);
   	 glTexImage2D(
   		 GL_TEXTURE_CUBE_MAP_POSITIVE_X + i,
   		 0, GL_RGBA, szerokosc, wysokosc, 0,
   		 GL_RGBA, GL_UNSIGNED_BYTE, tekstura);
    }
}

void COknoGL::UsuTekstury()
{
	//glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, NULL);
	glDeleteTextures(liczbaTekstur, indeksyTekstur);
	delete[] indeksyTekstur;	
	liczbaTekstur = 0;
}
#pragma endregion