﻿using System;
using System.ComponentModel;
using System.Windows.Threading;

namespace ZegarWPF.ModelWidoku
{
    public class Zegar : INotifyPropertyChanged
    {
        private DateTime poprzedniCzas = DateTime.Now;

        public DateTime AktualnyCzas
        {
            get
            {
                return DateTime.Now;
                //return new DateTime(2017, 12, 29, 18, 0, 15);
            }
        }

        public DateTime AktualnyCzasPłynny
        {
            get
            {
                return AktualnyCzas;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged()
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(AktualnyCzasPłynny)));

                if (AktualnyCzas - poprzedniCzas < TimeSpan.FromSeconds(1) &&
                AktualnyCzas.Second == poprzedniCzas.Second)
                    return;

                PropertyChanged(this, new PropertyChangedEventArgs(nameof(AktualnyCzas)));
            }
        }

        //private const int okresOdświeżaniaWidokuMs = 250; //0.25s
        private const int okresOdświeżaniaWidokuMs = 25; //0.025s

        private readonly bool isInDesignMode = DesignerProperties.GetIsInDesignMode(new System.Windows.DependencyObject());

        public Zegar()
        {
            DispatcherTimer timerOdświeżaniaWidoku = new DispatcherTimer();
            timerOdświeżaniaWidoku.Tick += (sender, e) => { onPropertyChanged(); };
            timerOdświeżaniaWidoku.Interval = TimeSpan.FromMilliseconds(okresOdświeżaniaWidokuMs);
            if (!isInDesignMode) timerOdświeżaniaWidoku.Start();            
        }
    }
}
