﻿using System;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.Effects;

namespace ZegarWPF
{
    class Efekt : ShaderEffect
    {
        //https://blogs.msdn.microsoft.com/greg_schechter/2008/05/12/writing-custom-gpu-based-effects-for-wpf/
        private static Uri getEffectUri(string efectFileName)
        {
            string assemblyShortName = typeof(Efekt).Assembly.ToString().Split(',')[0];
            string uriString = "pack://application:,,,/" + assemblyShortName + ";component/" + efectFileName;
            return new Uri(uriString);
        }

        private static PixelShader pixelShader = new PixelShader()
        {
            UriSource = getEffectUri("Efekt.ps")
        };

        public Efekt()
        {
            this.PixelShader = pixelShader;

            UpdateShaderValue(KolorProperty);
            UpdateShaderValue(InputProperty);
        }

        public static readonly DependencyProperty KolorProperty =
            DependencyProperty.Register("Kolor", typeof(Color), typeof(Efekt),
            new UIPropertyMetadata(Colors.White, PixelShaderConstantCallback(0)));

        public Color Kolor
        {
            get { return (Color)GetValue(KolorProperty); }
            set { SetValue(KolorProperty, value); }
        }

        public Brush Input
        {
            get { return (Brush)GetValue(InputProperty); }
            set { SetValue(InputProperty, value); }
        }

        public static readonly DependencyProperty InputProperty =
            RegisterPixelShaderSamplerProperty("Input", typeof(Efekt), 0);


        public static readonly DependencyProperty CzasProperty =
            DependencyProperty.Register("Czas", typeof(float), typeof(Efekt),
            new UIPropertyMetadata(0f, PixelShaderConstantCallback(1)));

        public float Czas
        {
            get { return (float)GetValue(CzasProperty); }
            set { SetValue(CzasProperty, value); UpdateShaderValue(CzasProperty); }
        }
    }
}
