#version 330 core

layout(location=0) in vec3 polozenie_in;
layout(location=1) in vec3 normalna_in;
layout(location=2) in vec2 wspTekstur_in;
layout(location=3) in vec4 kolor_in;

uniform bool UwzglednijKolorWerteksu = true;
uniform vec4 Kolor = vec4(1.0,1.0,0.0,1.0);

const mat4 macierzJednostkowa = mat4(1.0);
uniform mat4 macierzSwiata = macierzJednostkowa;
uniform mat4 macierzWidoku = macierzJednostkowa;
uniform mat4 macierzRzutowania = macierzJednostkowa;
mat4 macierzMVP = macierzRzutowania*macierzWidoku*macierzSwiata; //bardzo sabe, e to mnoenie jest w shaderze

//mat3 macierzNormalnych = mat3(1.0);
uniform mat4 macierzNormalnych = macierzJednostkowa;

out vec4 polozenie_1;
out vec4 kolor_1;
out vec2 wspTekstur_1;
out vec3 polozenie_scena_1;
out vec3 normalna_scena_1;
out vec2 polozenie_kamera_1;

void main(void)
{
	polozenie_1 = vec4(polozenie_in,1.0);
	gl_Position = macierzMVP*polozenie_1;
	polozenie_1 = macierzSwiata*polozenie_1;

	polozenie_scena_1 = mat3(macierzSwiata)*polozenie_in;
	normalna_scena_1 = mat3(macierzNormalnych)*normalna_in;
	
	kolor_1 = (UwzglednijKolorWerteksu)?kolor_in:Kolor;

	wspTekstur_1 = wspTekstur_in;

	polozenie_kamera_1 = gl_Position.xy;
}