#version 330 core

in vec4 polozenie_2;
in vec4 kolor_2;
in vec2 wspTekstur_2;
in vec3 polozenie_scena_2;
in vec3 normalna_scena_2;
in vec2 polozenie_kamera_2;

//parametry zrodla swiatla
uniform vec4 Ca = vec4(1,1,1,1);
uniform vec4 Cd = vec4(1,1,1,1);
uniform vec4 Cs = vec4(1,1,1,1);
uniform vec3 PolozenieZrodlaSwiatla = vec3(5,2,1);
uniform vec3 PolozenieKamery = vec3(0,0,1);

//parametry materialu
const float wa = 0.1;
const float wd = 1.0;
//const float ws = 0.3;
uniform vec4 Wa = vec4(wa,wa,wa,1);
uniform vec4 Wd = vec4(wd,wd,wd,1);
uniform vec4 Ws = vec4(0,1,0,1);
uniform float WNs = 100.0;

uniform bool Teksturowanie = true;
uniform sampler2D ProbnikTekstury;

vec4 ObliczKolorPhong(vec3 polozenie,vec3 normalna,vec4 kolor)
{
	vec3 R = polozenie;
	vec3 L = PolozenieZrodlaSwiatla-R;
	float odleglosc = length(L);
	L=normalize(L);
	vec3 N = normalize(normalna);
	float dotLN = dot(L,N);

	vec3 O = 2.0*dotLN*N-L;	//vec3 O = reflect(-L,N);
	vec3 V = normalize(PolozenieKamery-R);
	float dotOVn = pow(max(dot(O,V),0.0),WNs);

	dotLN = max(dotLN,0.0);

	vec4 teksel = vec4(1.0f, 1.0f, 1.0f, 1.0f);
	if(Teksturowanie) teksel = texture(ProbnikTekstury, wspTekstur_2);

	vec4 _kolor = Wa*Ca*kolor*teksel;
	_kolor+= Wd*Cd*kolor*teksel*dotLN;
	_kolor+= Ws*Cs*dotOVn;
	//_kolor = teksel; //Test teksturowania bez owietlenia
	return _kolor;
}

out vec4 kolor_out;

void main(void)
{
	kolor_out = ObliczKolorPhong(polozenie_scena_2,normalna_scena_2,kolor_2);
	//kolor_out = vec4(1,1,0,1);
}