#ifndef OPENGL_H
#define OPENGL_H

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1
#include <cstdlib> //m.in. exit

class COkno
{
private:
	bool ZmianaRozdzielczosci(long szerokosc, long wysokosc, long glebiaKolorow = 32) const;

protected:
	HWND uchwytOkna;
	long szerokoscObszaruUzytkownika;
	long wysokoscObszaruUzytkownika;

public:
	COkno() :uchwytOkna(NULL){};	
	bool Inicjuj(HINSTANCE uchwytAplikacji, POINT polozenieOkna, POINT rozmiarOkna, bool trybPelnoekranowy = false, bool zmianaRozdzielczosci = true);
	WPARAM Uruchom();
	LRESULT WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
};

#include "MacierzGL.h"
#include "Aktor.h"

enum TrybKontroliKamery { tkkFPP, tkkTPP, tkkArcBall, tkkModel };

class COknoGL : public COkno
{
private:
	HGLRC uchwytRC; //uchwyt kontekstu renderingu
	HDC uchwytDC; //uchwyt prywatnego kontekstu urzdzenia GDI
	bool UstalFormatPikseli(HDC uchwytDC) const;
	bool InicjujWGL(HWND uchwytOkna);
	void UsuWGL();	
	void UmieInformacjeNaPaskuTytuu(HWND uchwytOkna);

	unsigned int idProgramuShaderow;
	static unsigned int KompilujShader(const char* nazwaPliku, unsigned int typ, bool trybDebugowania = false);
	static unsigned int PrzygotujShadery(const char* vsNazwaPliku, const char* fsNazwaPliku, bool trybDebugowania = false);	

	void ustawCzas();

protected:
	void UstawienieSceny(bool rzutowanieIzometryczne = false);
	void RysujScen();

	Aktor** aktorzy;
	unsigned int liczbaAktorw;
	virtual unsigned int PrzygotujAktorw(); //zwraca liczb aktorw
	virtual void RysujAktorw();
	virtual void UsuAktorw();

	Macierz4 macierzwiata, macierzWidoku, macierzRzutowania, macierzNormalnych;
	
	typedef void (COknoGL::*TypMetodyObsugujcejPrzesunicieMyszy)(const POINT biecaPozycjaKursoraMyszy, const POINT przesunicieKursoraMyszy);

	virtual void ObsugaKlawiszy(WPARAM wParam);
	void ObliczaniePrzesuniciaMyszy(const LPARAM lParam, const float prg, POINT& poprzedniaPozycjaKursoraMyszy, TypMetodyObsugujcejPrzesunicieMyszy MetodaObsugujcaPrzesunicieMyszy);
	virtual void ObsugaMyszyZWcinitymLewymKlawiszem(const POINT biecaPozycjaKursoraMyszy, const POINT przesunicieKursoraMyszy);
	virtual void ObsugaMyszyZWcinitymPrawymKlawiszem(const POINT biecaPozycjaKursoraMyszy, const POINT przesunicieKursoraMyszy);
	virtual void ObsugaRolkiMyszy(WPARAM wParam);

	Wektor3 PobierzPooenieKamery(bool pomiObroty = false) const;
	float OdlegoKamery() const;
	TrybKontroliKamery trybKontroliKamery = tkkArcBall;
	void ModyfikujPooenieKamery(Macierz4 macierzPrzeksztacenia);

	bool swobodneObrotyKameryAktywne;
	virtual void SwobodneObrotyKamery(const bool inicjacja, const float pocztkowe_dx = 0, const float pocztkowe_dy = 0, const float wspczynnikWygaszania = 0);

	bool animacjaAktywna;
	virtual void AnimujScen();

	void UstawParametryrdawiata(Wektor3 pooenie, Wektor4 wiatoOtoczenia, Wektor4 wiatoRozpraszane, Wektor4 wiatoRozbysku);
	void UstawParametryMateriau(Wektor4 wiatoOtoczenia, Wektor4 wiatoRozpraszane, Wektor4 wiatoRozbysku, float wykadnikRozbysku);
	void UstawParametryOsabieniaOwietlenia(bool wczone, Wektor3 wspczynniki);

	const bool teksturowanieWczone;
	GLuint* indeksyTekstur;
	unsigned int liczbaTekstur;
	virtual void PrzygotujTekstury(unsigned int liczbaTekstur, char** nazwyPlikwTekstur);
	void UsuTekstury();

public:
	COknoGL() :COkno(), uchwytRC(NULL), uchwytDC(NULL), 
		macierzwiata(Macierz4::Jednostkowa), 
		macierzWidoku(Macierz4::Jednostkowa), 
		macierzRzutowania(Macierz4::Jednostkowa),
		macierzNormalnych(Macierz4::Jednostkowa),
		swobodneObrotyKameryAktywne(false), 
		animacjaAktywna(false), teksturowanieWczone(true) {};
	LRESULT WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
} okno;

typedef void (COknoGL::*MetodaObsugujcaPrzesunicieMyszy)(POINT biecaPozycjaKursoraMyszy, POINT przesunicieKursoraMyszy);

#endif
