using System;

using System.Data.Odbc; //ODBC
using System.Data; //DataSet
using System.Windows.Forms; //DataGrid

using System.IO; //StreamReader

using System.Data.SqlClient; //SQL

namespace JacekMatulewski.Data
{
	public class ConnectionMethods
	{
		public static DataSet ReadFromMSAccess(string filename,string table)
		{
			string cs = "Driver={Microsoft Access Driver (*.mdb)}; Dbq="+filename+";Uid=Admin;Pwd=;";
			OdbcConnection c= new OdbcConnection(cs);
			OdbcDataAdapter da = new OdbcDataAdapter("SELECT * FROM "+table,c);
			DataSet ds = new DataSet();
			c.Open();
			da.Fill(ds,table);
			c.Close();
			return ds;
		}

		public static DataSet ReadFromMSAccess(string filename,string table,DataGrid dataGrid)
		{
			DataSet ds=ReadFromMSAccess(filename,table);
			dataGrid.DataSource = ds.DefaultViewManager;
			return ds;
		}

		public static DataSet ReadFromXML(string filename)
		{
			StreamReader sr = new StreamReader(filename);
			DataSet ds = new DataSet();
			ds.ReadXml(sr);
			sr.Close();
			return ds;
		}

		public static DataSet ReadFromXML(string filename,DataGrid dataGrid)
		{
			DataSet ds=ReadFromXML(filename);
			dataGrid.DataSource=ds.DefaultViewManager;
			return ds;
		}

		public static DataSet ReadFromSQLServer(string databasename,string table)
		{
			string cs = "Data Source=.; Initial Catalog="+databasename+"; Integrated security=SSPI";
			SqlConnection c= new SqlConnection(cs);
			SqlDataAdapter da = new SqlDataAdapter("SELECT * FROM "+table,c);
			DataSet ds = new DataSet();
			c.Open();
			da.Fill(ds,table);
			c.Close();
			return ds;
		}

		public static DataSet ReadFromSQLServer(string databasename,string table,DataGrid dataGrid)
		{
			DataSet ds=ReadFromSQLServer(databasename,table);
			dataGrid.DataSource = ds.DefaultViewManager;
			return ds;
		}
	}
}
