using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using System.Reflection;

namespace ReversiDynDLL
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		static string komunikaty="";

		private const string nazwaPlikuDLL="JacekMatulewski.Reversi.dll";
		private const string nazwaKlasyRSAI="JacekMatulewski.Reversi.ReversiSilnikAI";
		private const string nazwaMetodyPNR="ProponujNajlepszyRuch";
		private const string typMetodyPNR="System.Int32[]";
		private const int liczbaArgumentowMetodyPNR=0;

		static private Assembly a=null;
		private System.Windows.Forms.RichTextBox richTextBox1;

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			try
				{
				//Tworzenie obiektu typu ReversiSilnikAI
				object silnik=a.CreateInstance(nazwaKlasyRSAI);
				MessageBox.Show("Utworzono obiekt typu "+silnik);
				komunikaty+="Utworzono obiekt typu "+silnik+"\n\n";

				//Uruchomienie metody ProponujNajlepszyRuch
				MethodInfo m=a.GetType(nazwaKlasyRSAI).GetMethod(nazwaMetodyPNR);
				int[] wspolrzedne=(int[])m.Invoke(silnik,null);

				MessageBox.Show("Proponowany ruch: ("+wspolrzedne[0]+","+wspolrzedne[1]+")");
				komunikaty+="Proponowany ruch: ("+wspolrzedne[0]+","+wspolrzedne[1]+")";

				richTextBox1.Text=komunikaty;
				}
			catch(Exception e)
				{
				MessageBox.Show("Utworzenie obiektu lub wywoanie metody nie powiodo si ("+e.Message+")");
				}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.richTextBox1 = new System.Windows.Forms.RichTextBox();
			this.SuspendLayout();
			// 
			// richTextBox1
			// 
			this.richTextBox1.Location = new System.Drawing.Point(16, 16);
			this.richTextBox1.Name = "richTextBox1";
			this.richTextBox1.Size = new System.Drawing.Size(256, 232);
			this.richTextBox1.TabIndex = 0;
			this.richTextBox1.Text = "richTextBox1";
			//
			// WinForm
			//
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(292, 268);
			this.Controls.Add(this.richTextBox1);
			this.Name = "WinForm";
			this.Text = "WinForm";
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			try
				{
				//Wczytywanie podzespou
				a=Assembly.LoadFrom(nazwaPlikuDLL);
				MessageBox.Show("Wczytano podzesp:\n"+a);
				komunikaty+="Wczytano podzesp:\n"+a+"\n\n";

				//Lista klas
				string nazwyTypow="Nazwy klas:\n";
				Type[] typy=a.GetTypes();
				foreach(Type typ in typy) nazwyTypow+=typ.FullName+"\n";
				MessageBox.Show(nazwyTypow);
				komunikaty+=nazwyTypow+"\n\n";

				//Szukanie klasy ReversiSilnikAI
				Type klasaRSAI=a.GetType(nazwaKlasyRSAI);
				if (klasaRSAI==null) throw new Exception("Nie znaleziono klasy "+nazwaKlasyRSAI);

				//Lista metod
				string nazwyMetod="Sygnatury metod:\n";
				MethodInfo[] metody=klasaRSAI.GetMethods();
				foreach(MethodInfo metoda in metody) nazwyMetod+=metoda+"\n";
				MessageBox.Show(nazwyMetod);
				komunikaty+=nazwyMetod+"\n\n";

				//Szukanie metody klasy ReversiSilnikAI
				MethodInfo metodaPNR=klasaRSAI.GetMethod(nazwaMetodyPNR);
				if (metodaPNR==null) throw new Exception("Nie znaleziono metody "+nazwaMetodyPNR);
				if (metodaPNR.ReturnType.ToString()!=typMetodyPNR) throw new Exception("Metody "+nazwaMetodyPNR+" zwraca inny ni oczekiwany typ wartoci");
				if (metodaPNR.GetParameters().Length>0) throw new Exception("Metoda "+nazwaMetodyPNR+" pobiera argumenty inne ni oczekiwane");

				/*
				//Lista parametrw
				ParameterInfo[] parametry=metodaPNR.GetParameters();
				string listaArgumentow="Lista argumentow:\n";
				foreach(ParameterInfo parametr in parametry)
					listaArgumentow+=parametr.Position+". "+parametr.ParameterType+" "+parametr.Name+"\n";
				MessageBox.Show(listaArgumentow);
				komunikaty+=listaArgumentow+"\n\n";
				*/
				}
			catch(Exception e)
				{
				MessageBox.Show("Wczytanie podzespou z pliku "+nazwaPlikuDLL+" nie powiodo si ("+e.Message+")\nAplikacja zostanie zakoczona.");
				return;
				}

			Application.Run(new WinForm());
		}
	}
}
