using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using System.Runtime.InteropServices;

namespace GetDiskFreeSpaceEx
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.ProgressBar progressBar1;

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//Odczytanie ilosc wolnego miejsca na C: za pomoca PInove/WinAPI
			long wolneMiejsceDlaUzytkownika=0;
			long rozmiarDysku=0;
			long wolneMiejsceNaDysku=0;
			if (GetDiskFreeSpaceEx("C:\\",ref wolneMiejsceDlaUzytkownika,ref rozmiarDysku,ref wolneMiejsceNaDysku))
				{
				progressBar1.Maximum=100;
				progressBar1.Value=(int)(100*(rozmiarDysku-wolneMiejsceNaDysku)/(double)rozmiarDysku);
				}
				else
				{
				MessageBox.Show("Nie udao si odczyta iloci wolnego miejsca na dysku");
				}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.progressBar1 = new System.Windows.Forms.ProgressBar();
			this.SuspendLayout();
			// 
			// progressBar1
			// 
			this.progressBar1.Location = new System.Drawing.Point(8, 8);
			this.progressBar1.Name = "progressBar1";
			this.progressBar1.Size = new System.Drawing.Size(272, 40);
			this.progressBar1.TabIndex = 0;
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(292, 56);
			this.Controls.Add(this.progressBar1);
			this.Name = "WinForm";
			this.Text = "WinForm";
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new WinForm());
		}

	 /*
		BOOL GetDiskFreeSpaceEx(
			LPCTSTR lpDirectoryName,	// pointer to directory name on disk of interest
			PULARGE_INTEGER lpFreeBytesAvailableToCaller,	// pointer to variable to receive free bytes on disk available to the caller
			PULARGE_INTEGER lpTotalNumberOfBytes,	// pointer to variable to receive number of bytes on disk
			PULARGE_INTEGER lpTotalNumberOfFreeBytes	// pointer to variable to receive free bytes on disk
		   );
	 */
		[DllImport("kernel32.dll")]
		static extern bool GetDiskFreeSpaceEx(string katalog,ref long wolneMiejsceDlaUzytkownika,ref long rozmiarDysku,ref long wolneMiejsceNaDysku);
	}
}
